# Vespucci 20.0 Highlights

2024-03-11

### OAuth 2 support

This version adds support for OAuth 2 authorization, new installs will have this configured as default for the regular openstreetmap.org and developer sandbox API configurations. Existing
installations will get a one time indication that they should migrate with a "one click" way to do this on updates, however this can be skipped and the migration can be executed manually.

For the foreseeable future we will continue to support OAuth 1.0a and login / password authentication.  

### End of support for Android 4.1 to 4.4 postponed

Instead of in this version we will be removing the support in version 20.1 which will likely be available in the third quarter of 2024. For further details please see the [19.3 release notes](19.3.0%20Release%20notes.md).

### Create circle and align nodes in circle improvements

We've added a _Create circle_ function that will create a circle from three selected nodes, and have modified the _Align in circle_ method to add nodes. The minimum number of nodes in a circle, the maximum circle segment length, and the minimum circle segment length can be set in the [Advanced preferences](Advanced%20preferences.md).

### Follow way

When creating a new way by using nodes of an existing way Vespucci can now follow the existing way to a node on the way. This can be done multiple times during the process of creating the new way.

### Support localised values in presets and improved formatting support

Since version 14.0 released in October 2019 we have supported region specific preset items, version 20 takes this further by supporting localization at the level of individual preset values level. This allows, for example, country specific payment options in the payment preset only to be shown for objects in that country without the need to create a full country specific item.

Additionally we have added support for _space_ and _item_separator_ elements that help to make the tag form visually easier to digest. 

### Improved conflict handling

Conflict resolution have been substantially improved making at least simple cases much easier to handle on the road. Please see the dedicated help page on [Conflict resolution](Conflict%20resolution.md) for more information.

### Support for opening OpenStreetMap website links

Vespucci now supports opening element and note links on openstreetmap.org in the app if these are opened on another website (so not for navigation on openstreetmap.org itself). Depending on the Android version you may have to enable this in the system app configuration.

Example [https://openstreetmap.org/node/1](https://openstreetmap.org/node/1) will download (if it isn't already loaded), zoom to and select node 1.

### Improved new user onboarding

New installs can now configure some important setting in the welcome dialog and directly start the app authorization process.

### Mode switching available from menu

To make the functionality more discoverable, mode switching is now available from the _Modes_ entry in the main overflow menu additionally to from the lock button. Enabling or disabling of _Simple mode_ has moved to the submenu too for consistency reasons. 

## Miscellaneous

- Better error handling when auto-downloading
- Added some new style "expressions" for use in filters to mapbox-gl support
- Add mobile and contact:mobile to phone keys
- Sort relation lists by distance to an OsmElement or list of them
- Support CRS:84 for wms imagery configuration and endpoints, inherit CRS/SRS values
- Handle hidden notes
- Align how the way rotation mode work more with the similar modes
- Validate connections to multi-polygons with appropriate tags
- Improve how we handle closed ways with indication that they are areas
- More keyboard shortcuts and update documentation
- Use number of current download bounding boxes as further prune condition
- Add natural=earth_bank to non-reversible tags
- Add bounding box count display to data and task info modal
- Support translations of tile layer names and descriptions
- Support for multiple file selection for creating layers (GPX and GeoJSON)
- Make using the volume keys for zooming dependent on a preference
- Add image information modal to image viewer
- Add explicit handling for 509 error on download and 429 in upload
- Add start app via upload reminder notification

# Upgrading from previous versions

* As the saved state file has changed you should upload any pending changes before updating.

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
